/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurve2DUtils;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CirculinearBoundarySet2D<T extends CirculinearContour2D>
extends CirculinearContourArray2D<T> {
    public static <T extends CirculinearContour2D> CirculinearBoundarySet2D<T> create(Collection<T> curves) {
        return CirculinearBoundarySet2D.create(curves);
    }

    public static <T extends CirculinearContour2D> CirculinearBoundarySet2D<T> create(T ... curves) {
        return new CirculinearBoundarySet2D<T[]>(curves);
    }

    public CirculinearBoundarySet2D() {
        this.curves = new ArrayList();
    }

    public CirculinearBoundarySet2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CirculinearBoundarySet2D(T ... curves) {
        this.curves = new ArrayList(curves.length);
        T[] TArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.addCurve(element);
            ++n2;
        }
    }

    public CirculinearBoundarySet2D(T curve) {
        this.curves = new ArrayList();
        this.curves.add(curve);
    }

    public CirculinearBoundarySet2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.getCurves()) {
            sum += curve.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        return CirculinearCurve2DUtils.getLength(this, pos);
    }

    @Override
    public double getPosition(double length) {
        return CirculinearCurve2DUtils.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearBoundary2D getParallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createParallelBoundary(this, d);
    }

    @Override
    public CirculinearBoundarySet2D<? extends CirculinearContour2D> transform(CircleInversion2D inv) {
        CirculinearBoundarySet2D<CirculinearContour2D> result = new CirculinearBoundarySet2D<CirculinearContour2D>(this.curves.size());
        for (CirculinearContour2D curve : this.curves) {
            result.addCurve(curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<T> getContinuousCurves() {
        ArrayList result = new ArrayList(this.curves.size());
        result.addAll(this.curves);
        return result;
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CirculinearCurveArray2D<CirculinearContinuousCurve2D> result = new CirculinearCurveArray2D<CirculinearContinuousCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CirculinearContinuousCurve2D)) continue;
            result.addCurve((CirculinearContinuousCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public CirculinearBoundarySet2D<? extends CirculinearContour2D> getReverseCurve() {
        int n = this.curves.size();
        CirculinearContour2D[] curves2 = new CirculinearContour2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = ((CirculinearContour2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new CirculinearBoundarySet2D<CirculinearContour2D[]>(curves2);
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> getSubCurve(double t0, double t1) {
        Curve2D curveSet = super.getSubCurve(t0, t1);
        ArrayList<CirculinearContinuousCurve2D> curves = new ArrayList<CirculinearContinuousCurve2D>(curveSet.getCurveNumber());
        for (Curve2D curve : curveSet.getCurves()) {
            curves.add((CirculinearContinuousCurve2D)curve);
        }
        return CirculinearCurveArray2D.create(curves);
    }
}

